package gov.va.med.mhv.vitals.repository;

import gov.va.med.mhv.vitals.model.BloodSugarReading;

import java.util.List;

import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface BloodSugarReadingRepository extends JpaRepository<BloodSugarReading, Long>{
	
     @Query("select a from BloodSugarReading a where a.userprofileId = :userprofileid order by a.reading desc")
	 List<BloodSugarReading>  getBloodSugarReadingsForUser(@Param ("userprofileid") Long userprofileid);
     
     
     @Query("select a from BloodSugarReading a where a.userprofileId = :userprofileid order by a.reading desc")
	 List<BloodSugarReading>  getDashBoardBloodSugarReadingsForUser(@Param ("userprofileid") Long userprofileid,Pageable page);



}
